import java.awt.Point;
import java.awt.Toolkit;
import java.util.concurrent.ThreadLocalRandom;

import wheels.users.Ellipse;
import wheels.users.Rectangle;

public class Ball extends Ellipse
{
	private Vector2d direction;
	private Vector2d position;
	
	enum BounceAgainst
	{
		Bottom,
		Left,
		Right,
		Top
	}
	
	public Ball()
	{
		super(java.awt.Color.orange);
		this.setSize(20, 20);
		
		reset();
	}
	
	public void update()
	{
		this.position.x += this.direction.x;
		this.position.y += this.direction.y;
		
		this.setLocation((int)Math.floor(this.position.x), (int)Math.floor(this.position.y));
		this.setLocation((int)Math.floor(this.position.x), (int)Math.floor(this.position.y));
		
		Toolkit.getDefaultToolkit().sync();
	}
	
	public boolean intersect(Rectangle object)
	{
		return this._shape.intersects(object.getXLocation(), object.getYLocation(), object.getWidth(), object.getHeight());
	}

	public void bounce(Rectangle object)
	{
		final int x = this.getXLocation();
		final int y = this.getYLocation();
		
		final int side = this.getWidth();
		
		final Point pointTop = new Point(x + side / 2, y);
		final Point pointRight = new Point(x + side, y + side / 2);
		final Point pointBottom = new Point(x + side / 2, y + side);
		final Point pointLeft = new Point(x, y + side / 2);
        
		
        if (object.contains(pointLeft))
        {
            this.direction.x = -this.direction.x;
        }
        else if (object.contains(pointRight))
        {
        	this.direction.x = -this.direction.x;
        }  
        else if (object.contains(pointBottom))
        {
        	this.direction.y = -this.direction.y;
        }
        else if (object.contains(pointTop))
        {
        	this.direction.y = -this.direction.y;
        }
	}

	public void reset()
	{
		final int width = ThreadLocalRandom.current().nextInt(-15, 15);
		final double height = ThreadLocalRandom.current().nextDouble(-0.1, 0.1);
		
		this.position = new Vector2d(45 + width,  Window._dp.getHeight() * (0.75 + height));
		this.direction = new Vector2d(Math.cos(0), -1);
	}
}
