import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import wheels.users.Rectangle;

public class Borders extends Rectangle
{
	private List<Rectangle> borders = new ArrayList<Rectangle>();
	private Rectangle thevoid;
	
	public Borders()
	{
		borders.add(generate(new Point(-45, 0), 50, this._dp.getHeight()));
		borders.add(generate(new Point(Window._dp.getWidth() - 5, 0), 50, this._dp.getHeight()));
		borders.add(generate(new Point(0, -45), Window._dp.getWidth(), 50));
		
		thevoid = generate(new Point(-50, this._dp.getHeight() + 20), Window._dp.getWidth() + 100, 50);
	}
	
	public boolean update(Ball ball)
	{
		for (Rectangle border : borders)
		{
			if (ball.intersect(border))
			{
				ball.bounce(border);
			}
		}
		
		return ball.intersect(thevoid);
	}
	
	private Rectangle generate(Point location, final int x, final int y)
	{
		Rectangle temporary = new Rectangle(java.awt.Color.gray);
		temporary.setLocation(location);
		temporary.setSize(x, y);
		
		return temporary;
	}
}