import java.awt.*;
import wheels.users.Rectangle;

public class Brick extends Rectangle
{
	private int hitcount;
	
	public Brick(final Point location, final int hitcount)
	{
		this.setLocation(location);
		this.setSize( new Dimension(67, 20));
		this.hitcount = hitcount;
		
		recolor();
	}
	
	/*
	 * Return true if to bounce against it
	 */
	public boolean decrease()
	{
		if (hitcount != 0)
		{
			hitcount -= 1;
			recolor();
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public boolean destroyed()
	{
		return hitcount == 0 ? true : false;
	}
	
	private void recolor()
	{
		switch (hitcount)
		{
			case 0:
				this.setColor(java.awt.Color.black);
				break;
		
			case 1:
				this.setColor(java.awt.Color.green);
				break;
			
			case 2:
				this.setColor(java.awt.Color.orange);
				break;
			
			case 3:
				this.setColor(java.awt.Color.red);
				break;
			
			case 4:
				this.setColor(java.awt.Color.cyan);
				break;

			case 5:
				this.setColor(java.awt.Color.blue);
				break;
			
			case 6:
				this.setColor(java.awt.Color.pink);
				break;
			
			case 7:
				this.setColor(java.awt.Color.darkGray);
				break;
			
			case 8:
				this.setColor(java.awt.Color.yellow);
				break;
				
			case 9:
				this.setColor(java.awt.Color.magenta);
				break;
				
			default:
				break;
		}
	}
}
