import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class BrickWall
{
	private List<Brick> bricks = new ArrayList<Brick>();
	
	public BrickWall()
	{
		for(int line = 0; line < 5; line++)
		{
			for(int column = 0; column < 8; column++)
			{	
				final int random = ThreadLocalRandom.current().nextInt(1, 10);
				bricks.add(new Brick(new Point(47 + (76 * column), 67 + (30 * line)), random));
			}
		}
	}
	
	public void lost()
	{
		for (Brick brick : bricks)
		{
			brick.setColor(java.awt.Color.red);
		}
		
	}
	public void win()
	{
		for (Brick brick : bricks)
		{
			brick.setColor(java.awt.Color.green);
		}
	}
	
	public boolean destroyed()
	{
		for (Brick brick : bricks)
		{
			if (!brick.destroyed())
			{
				return false;
			}
		}
		return true;
	}
	
	// Return points to add 
	public int update(Ball ball)
	{
		for (Brick brick : bricks)
		{
			if (ball.intersect(brick))
			{
				if (brick.decrease())
				{
					ball.bounce(brick);
					return 1;
				}
			}
		}
		return 0;
	}
}
