import java.util.*;
import wheels.users.*;

public class Life
{
	private List<Ellipse> balls = new ArrayList<Ellipse>();
	
	public Life(final int max)
	{
		for(int index = 0; index < max; index++)
		{
			balls.add(generate(index));
		}
	}
	
	public boolean alive()
	{
		return balls.isEmpty() ? false : true;
	}
	
	public void decrease()
	{
		if (!balls.isEmpty())
		{
			balls.get(balls.size() - 1).hide();
			balls.remove(balls.size() - 1);
		}
	}
	
	private Ellipse generate(final int index)
	{
		Ellipse temporary = new Ellipse(java.awt.Color.orange);
		temporary.setLocation(20 + (index * 27), 20);
		temporary.setSize(20, 20);
		
		return temporary;
	}
}
