import java.awt.event.MouseEvent;
import java.awt.*;
import wheels.users.Rectangle;
import java.awt.event.MouseMotionListener;

public class Player extends Rectangle implements MouseMotionListener
{
	public Life life;
	
	public Player()
	{
		this.life = new Life(3);
		
		this.setLocation(new Point(30, 450));
		this.setColor(java.awt.Color.white);
		this.setSize( new Dimension(78, 10));
	}
	
	public void autoplay(Ball ball)
	{
		this.setLocation(ball.getXLocation() - this.getSize().width / 2, this.getYLocation());
		update(ball);
	}
	
	public void update(Ball ball)
	{
		if (ball.intersect(this))
		{
			ball.bounce(this);
		}
	}
	
	@Override
	public void mouseMoved(final MouseEvent e)
	{
		this.setLocation(e.getPoint().x - this.getSize().width / 2, this.getYLocation());
	}
}
